package gov.va.med.mhv.usermgmt.converter;

import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.data.model.Activity;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class ActivityConverter implements Converter<Activity, ActivityDTO> {
	
	@Override
	public ActivityDTO convert(Activity activity) {
		ActivityDTO dto = new ActivityDTO();
		dto.setAction(activity.getAction());
		dto.setActivityId(activity.getActivityId());
		dto.setActivityType(activity.getActivityType());
		dto.setCompletionTime(activity.getCompletionTime());
		if(activity.getDetailValue() != null) {
			dto.setDetailValue(abbreviateString(activity.getDetailValue(),255));
		}
		dto.setPerformerType(activity.getPerformerType());
		dto.setStatus(activity.getStatus());
		dto.setUserProfileId(activity.getUserProfileId());

		return dto;
	}

	public Activity convert(ActivityDTO activityDTO) {
		Activity activity = new Activity();
		activity.setAction(activityDTO.getAction());
		activity.setActivityId(activity.getActivityId());
		activity.setActivityType(activityDTO.getActivityType());
		activity.setCompletionTime(activityDTO.getCompletionTime());
		if(activityDTO.getDetailValue() != null) {
			activity.setDetailValue(abbreviateString(activityDTO.getDetailValue(),255));
		}
		activity.setPerformerType(activityDTO.getPerformerType());
		activity.setStatus(activityDTO.getStatus());
		activity.setUserProfileId(activityDTO.getUserProfileId());

		return activity;
	}

	public List<ActivityDTO> convertDomainActivities(List<Activity> acitivities) {
		List<ActivityDTO> activityDTOS = new ArrayList<ActivityDTO>();
		for (Activity activity : acitivities) {
			ActivityDTO dto = convert(activity);
			activityDTOS.add(dto);
		}
		return activityDTOS;
	}
	private static String abbreviateString(String input, int maxLength) {
	    if (input.length() <= maxLength) 
	        return input;
	    else 
	        return input.substring(0, maxLength-2) + "..";
	}
}
